/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xserial.h
 * -----------------------------------------------------------------*/

#ifndef XSERIAL_H_INCLUDED
#define XSERIAL_H_INCLUDED

#include <xtypedef.h>
#include <xio.h>

extern bx_handlestype bx_handlearray[];    /*lint !e762 redundant declaration */

/* --------------------------------------------------------------------------
 * These declarations are common to all OS's.  Note that the meaning of 
 * OsHandle is OS-dependent.
 * -------------------------------------------------------------------------- */

#define SER_RCV_TIMEOUT   600000UL

bx_portnumtype BestXOpenCOMInitial(int num, bx_int32 baudrate);

/* set COM port settings and baudrate */
bx_errtype BestXSerInit(bx_portnumtype OsHandle, bx_int32 baudrate );

void BestXCloseSerial(bx_portnumtype portnumber);

/* BestXSerSetRegwidth() not needed */
  bx_errtype BestXSerDeviceConnect(bx_portnumtype OsHandle);
  bx_errtype BestXSerCheckConnection(bx_portnumtype OsHandle);
void BestXSerReleaseConnection(bx_portnumtype OsHandle);

  bx_errtype BestXSerOnReadOrWriteError(bx_portnumtype OsHandle);
  bx_errtype BestXSerPortTimeoutSet(bx_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts);

/* Default timeouts are defined in bx_io.h */

/* --------------------------------------------------------------------------
 * These declarations are not always used (OS-DEPENDENT)
 * -------------------------------------------------------------------------- */

  bx_errtype BestXSerBasicRead(
  bx_handletype handle,
  bx_int8ptr pData,
  bx_int32 NumBytes,
  bx_int32 * NumBytesRead);

  bx_errtype BestXSerBasicWrite(
  bx_handletype handle,
  bx_int8ptr pData,
  bx_int32 NumBytes,
  bx_int32 * NumBytesWritten);

#endif /* _BX_SERIAL_H_ */
